/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.InterpolatingDelayUnit;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.SawtoothOscillatorBL;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOscillator;
import com.softsynth.jsyn.view11x.ExponentialPortFader;
import com.softsynth.jsyn.view11x.PortFader;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;

public class InterAuralTimeDelay
extends Applet {
    LineOut lineOut;
    SynthOscillator sawOsc;
    SynthEnvelope sgEnvData;
    ExponentialLag expLag;
    MultiplyAddUnit scaler;
    EnvelopePlayer sgEnv;
    InterpolatingDelayUnit rightDelay;
    InterpolatingDelayUnit leftDelay;
    double[] envData = new double[]{0.002, 1.0, 0.1, 0.1, 0.5, 0.0};
    static final double MAX_DELAY = 0.2;

    public static void main(String[] args) {
        InterAuralTimeDelay applet = new InterAuralTimeDelay();
        AppletFrame frame = new AppletFrame("Interaural Time Delay", applet);
        frame.resize(600, 120);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        try {
            Synth.requestVersion(141);
            Synth.startEngine(0);
            this.expLag = new ExponentialLag();
            this.sawOsc = new SawtoothOscillatorBL();
            this.sgEnvData = new SynthEnvelope(this.envData);
            this.sgEnv = new EnvelopePlayer();
            this.lineOut = new LineOut();
            this.rightDelay = new InterpolatingDelayUnit(0.2);
            this.rightDelay.delay.set(0.1);
            this.leftDelay = new InterpolatingDelayUnit(0.2);
            this.scaler = new MultiplyAddUnit();
            this.scaler.inputA.set(0.001);
            this.scaler.inputC.set(0.1);
            this.expLag.output.connect(this.scaler.inputB);
            this.scaler.output.connect(this.leftDelay.delay);
            this.sawOsc.output.connect(this.sgEnv.amplitude);
            this.sgEnv.output.connect(this.rightDelay.input);
            this.sgEnv.output.connect(this.leftDelay.input);
            this.leftDelay.output.connect(0, this.lineOut.input, 0);
            this.rightDelay.output.connect(0, this.lineOut.input, 1);
            this.setLayout(new GridLayout(0, 1));
            this.add(new PortFader(this.expLag.input, "Interaural Time Delay (msec)", 0.0, -3.0, 3.0));
            this.add(new ExponentialPortFader(this.sawOsc.amplitude, 0.1, 0.001, 1.0));
            this.add(new ExponentialPortFader(this.sawOsc.frequency, 110.0, 40.0, 5000.0));
            this.expLag.start();
            this.sawOsc.start();
            this.sgEnv.start();
            this.lineOut.start();
            this.scaler.start();
            int now = Synth.getTickCount();
            int then = now + (int)(Synth.getTickRate() * 0.5);
            this.rightDelay.start(then);
            this.leftDelay.start(then);
            this.sgEnv.envelopePort.queueLoop(this.sgEnvData);
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

