/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.util.BussedVoiceAllocator;

class PitchedVoices {
    BussedVoiceAllocator allocator;
    SynthNote[] voices;
    double[] frequencies;
    int numPitches;

    public PitchedVoices(BussedVoiceAllocator allocator, double[] frequencies) {
        this.allocator = allocator;
        this.frequencies = frequencies;
        this.numPitches = frequencies.length;
        this.voices = new SynthNote[this.numPitches];
    }

    public SynthNote noteOn(int pitchIndex, double amplitude) {
        SynthNote voice = null;
        if (this.voices[pitchIndex] == null) {
            this.voices[pitchIndex] = voice = (SynthNote)this.allocator.steal();
            voice.noteOn(Synth.getTickCount(), this.frequencies[pitchIndex], amplitude);
        }
        return voice;
    }

    public SynthNote noteOff(int pitchIndex) {
        SynthNote voice = null;
        voice = this.voices[pitchIndex];
        if (voice != null) {
            voice.noteOff(Synth.getTickCount());
            this.voices[pitchIndex] = null;
            this.allocator.free(voice);
        }
        return voice;
    }
}

