/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.view102.XYController;
import java.awt.Color;
import java.awt.Graphics;

public class SpinningPhaser
extends XYController
implements Runnable {
    double angle = 0.0;
    boolean die = false;
    Thread thread;
    int duration = 60;
    double increment = 0.1;

    public SpinningPhaser() {
        super(-1.0, -1.0, 1.0, 1.0);
    }

    void setDuration(int dur) {
        this.duration = dur;
    }

    void setIncrement(double incr) {
        this.increment = incr;
    }

    void start() {
        this.stop();
        this.thread = new Thread(this);
        this.thread.start();
    }

    double getAngle() {
        return this.angle;
    }

    void stop() {
        this.die = true;
        try {
            if (this.thread != null) {
                this.thread.join(5000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    @Override
    public void run() {
        this.die = false;
        while (!this.die) {
            this.angle += this.increment;
            while (this.angle > Math.PI * 2) {
                this.angle -= Math.PI * 2;
            }
            this.repaint();
            try {
                Thread.sleep(this.duration);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        int width = this.bounds().width;
        int height = this.bounds().height;
        g.setColor(Color.cyan);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.black);
        int x1 = this.convertWXtoGX(0.0);
        int y1 = this.convertWYtoGY(0.0);
        int x2 = this.convertWXtoGX(Math.cos(this.angle));
        int y2 = this.convertWYtoGY(Math.sin(this.angle));
        g.drawLine(x1, y1, x2, y2);
        g.setColor(Color.blue);
        g.drawLine(0, y2, width, y2);
        g.setColor(Color.red);
        g.fillArc(x2 - 2, y2 - 2, 6, 6, 0, 360);
    }
}

