/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SampleReader_16F1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.view102.LabelledFader;
import com.softsynth.jsyn.view102.PortFader;
import com.softsynth.jsyn.view102.Tweakable;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;

public class TicksToTone
extends Applet
implements Tweakable {
    SynthSample mySamp;
    SampleReader_16F1 mySampler;
    LineOut myOut;
    final int NUM_TOTAL_FRAMES = 22050;
    short[] data;
    LabelledFader octaveFader;
    Label freqLabel;
    final int NUM_OCTAVES = 10;

    public TicksToTone() {
        short[] sArray = new short[12];
        sArray[1] = 1000;
        sArray[2] = 2000;
        sArray[3] = 6000;
        sArray[4] = 20000;
        sArray[5] = 32000;
        sArray[6] = -32000;
        sArray[7] = -20000;
        sArray[8] = -6000;
        sArray[9] = -2000;
        sArray[10] = -1000;
        this.data = sArray;
        this.NUM_OCTAVES = 10;
    }

    public static void main(String[] args) {
        TicksToTone applet = new TicksToTone();
        AppletFrame frame = new AppletFrame("Ticks To Tone", applet);
        System.out.println("Java version = " + System.getProperty("java.version"));
        frame.resize(600, 200);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            this.mySamp = new SynthSample(22050);
            this.mySamp.write(22050 - this.data.length, this.data, 0, this.data.length);
            this.mySampler = new SampleReader_16F1();
            this.myOut = new LineOut();
            this.mySampler.samplePort.queueLoop(this.mySamp, 0, 22050);
            this.mySampler.output.connect(0, this.myOut.input, 0);
            this.mySampler.output.connect(0, this.myOut.input, 1);
            this.add(new PortFader(this.mySampler.amplitude, 0.5, 0.0, 1.0));
            this.octaveFader = new LabelledFader(this, 1, "Octave", 1.0, 1.0, 10.0);
            this.add(this.octaveFader);
            this.freqLabel = new Label();
            this.add(this.freqLabel);
            this.tweak(1, 1.0);
            this.myOut.start();
            this.mySampler.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.mySampler.delete();
            this.mySampler = null;
            this.myOut.delete();
            this.myOut = null;
            this.removeAll();
            Synth.verbosity = 0;
            System.out.println("TicksToTone: stopping engine");
            Synth.stopEngine();
            System.out.println("TicksToTone: stopped");
        }
        catch (SynthException e) {
            System.out.println("Caught " + e);
        }
    }

    @Override
    public void tweak(int targetIndex, double val) {
        switch (targetIndex) {
            case 1: {
                double freq = Math.pow(2.0, val);
                int numFrames = (int)(Synth.getFrameRate() / freq);
                if (numFrames > 22050) {
                    System.out.println("Exceeded NUM_TOTAL_FRAMES with " + numFrames);
                    numFrames = 22050;
                } else if (numFrames < this.data.length) {
                    System.out.println("Below pulse length with " + numFrames);
                    numFrames = this.data.length;
                }
                this.mySampler.samplePort.queue(this.mySamp, 22050 - numFrames, numFrames, 136);
                String freqString = Double.toString(freq);
                int maxchars = freqString.indexOf(46) + 5;
                String actualString = freqString.length() > maxchars ? freqString.substring(0, maxchars) : freqString;
                this.freqLabel.setText("Frequency = " + actualString + " Hz");
            }
        }
    }
}

