/*
 * Decompiled with CFR 0.152.
 */
package usertest;

import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.view11x.SoundTester;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class NestedCircuits
extends SynthNote {
    MySubCircuit circuit;

    public NestedCircuits() {
        this(Synth.getSharedContext());
    }

    public NestedCircuits(SynthContext synthContext) {
        super(synthContext);
        this.circuit = new MySubCircuit(synthContext);
        this.add(this.circuit);
        this.output = this.circuit.output;
        this.addPort(this.output, "output");
    }

    @Override
    public void setStage(int time, int stage) {
        switch (stage) {
            case 0: {
                this.start(time);
                break;
            }
            case 1: {
                break;
            }
        }
        this.circuit.setStage(time, stage);
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                System.exit(0);
            }
        });
        Synth.startEngine(0);
        LineOut out = new LineOut();
        out.start();
        NestedCircuits sn = new NestedCircuits();
        sn.output.connect(0, out.input, 0);
        sn.output.connect(0, out.input, 1);
        SoundTester tester = new SoundTester(sn);
        f.add(tester);
        f.pack();
        f.setVisible(true);
    }

    static class MySubCircuit
    extends SynthNote {
        public SineOscillator sawBL;

        public MySubCircuit() throws SynthException {
            this(Synth.getSharedContext());
        }

        public MySubCircuit(SynthContext synthContext) throws SynthException {
            super(synthContext);
            this.sawBL = new SineOscillator(synthContext);
            this.add(this.sawBL);
            this.frequency = this.sawBL.frequency;
            this.addPort(this.frequency);
            this.amplitude = this.sawBL.amplitude;
            this.addPort(this.amplitude);
            this.output = this.sawBL.output;
            this.addPort(this.output);
            this.amplitude.setup(0.0, 0.3, 1.0);
            this.frequency.setup(0.0, 160.0, 2000.0);
        }

        @Override
        public void setStage(int time, int stage) throws SynthException {
            switch (stage) {
                case 0: {
                    this.start(time);
                    break;
                }
            }
        }
    }
}

