/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import javax.swing.DefaultBoundedRangeModel;

public class DoubleBoundedRangeModel
extends DefaultBoundedRangeModel {
    private static final long serialVersionUID = 284361767102120148L;
    protected String name;
    private double dmin;
    private double dmax;

    public DoubleBoundedRangeModel(String name, int resolution, double dmin, double dmax, double dval) {
        this.name = name;
        this.dmin = dmin;
        this.dmax = dmax;
        this.setMinimum(0);
        this.setMaximum(resolution);
        this.setDoubleValue(dval);
    }

    public boolean equivalentTo(Object other) {
        if (!(other instanceof DoubleBoundedRangeModel)) {
            return false;
        }
        DoubleBoundedRangeModel otherModel = (DoubleBoundedRangeModel)other;
        return this.getValue() == otherModel.getValue();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public double getDoubleMinimum() {
        return this.dmin;
    }

    public double getDoubleMaximum() {
        return this.dmax;
    }

    public double sliderToDouble(int sliderValue) {
        double doubleMin = this.getDoubleMinimum();
        return doubleMin + (this.getDoubleMaximum() - doubleMin) * (double)sliderValue / (double)this.getMaximum();
    }

    public int doubleToSlider(double dval) {
        double doubleMin = this.getDoubleMinimum();
        return (int)Math.round((double)this.getMaximum() * (dval - doubleMin) / (this.getDoubleMaximum() - doubleMin));
    }

    public double getDoubleValue() {
        return this.sliderToDouble(this.getValue());
    }

    public void setDoubleValue(double dval) {
        this.setValue(this.doubleToSlider(dval));
    }
}

