/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.ports.UnitPort;
import com.jsyn.unitgen.UnitGenerator;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class Circuit
extends UnitGenerator {
    private ArrayList<UnitGenerator> units = new ArrayList();
    private final LinkedHashMap<String, UnitPort> portAliases = new LinkedHashMap();

    @Override
    public void generate(int start, int limit) {
        for (UnitGenerator unit : this.units) {
            unit.generate(start, limit);
        }
    }

    @Override
    public void flattenOutputs() {
        for (UnitGenerator unit : this.units) {
            unit.flattenOutputs();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (UnitGenerator unit : this.units) {
            unit.setEnabled(enabled);
        }
    }

    @Override
    @Deprecated
    public void setFrameRate(int frameRate) {
        super.setFrameRate(frameRate);
        for (UnitGenerator unit : this.units) {
            unit.setFrameRate(frameRate);
        }
    }

    @Override
    public void setSynthesisEngine(SynthesisEngine engine) {
        super.setSynthesisEngine(engine);
        for (UnitGenerator unit : this.units) {
            unit.setSynthesisEngine(engine);
        }
    }

    public void add(UnitGenerator unit) {
        this.units.add(unit);
        unit.setCircuit(this);
        unit.setEnabled(this.isEnabled());
    }

    public void usePreset(int presetIndex) {
    }

    public void addPortAlias(UnitPort port, String alias) {
        this.portAliases.put(alias.toLowerCase(), port);
    }

    @Override
    public UnitPort getPortByName(String portName) {
        UnitPort port = super.getPortByName(portName);
        if (port == null) {
            port = this.portAliases.get(portName.toLowerCase());
        }
        return port;
    }
}

