/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.compose;

import com.softsynth.compose.BasicContext;
import com.softsynth.compose.ChordProgression;
import com.softsynth.compose.ChordProgressionFactory;
import com.softsynth.compose.Composer;
import com.softsynth.compose.Scale;
import com.softsynth.score.Column;
import com.softsynth.score.ScoreElement;
import com.softsynth.score.ScoreInstrument;
import com.softsynth.score.ScoreNote;
import com.softsynth.score.Sequence;

public class ChordComposer
implements Composer {
    private ScoreInstrument rhythmInstrument;
    private BasicContext context;
    private ChordProgression chordProgression;
    private int cursor;

    public ChordComposer(BasicContext context, ScoreInstrument rhythmInstrument, ChordProgression chordProgression) {
        this.context = context;
        this.rhythmInstrument = rhythmInstrument;
        this.chordProgression = chordProgression;
    }

    public ChordComposer(BasicContext context, ScoreInstrument rhythmInstrument) {
        this(context, rhythmInstrument, ChordProgressionFactory.createRandom());
    }

    private synchronized int nextChord() {
        if (this.cursor >= this.chordProgression.size()) {
            this.cursor = 0;
        }
        int index = this.chordProgression.get(this.cursor++);
        return index;
    }

    @Override
    public ScoreElement nextElement() {
        double measureDuration;
        Sequence sequence = new Sequence();
        sequence.setInstrument(this.rhythmInstrument);
        double duration = 1.0;
        int index = this.nextChord();
        System.out.println("chord degree = " + this.chordProgression.getName(index));
        this.context.chordScale = this.context.scale.createTriad(index);
        double timeLeft = measureDuration = this.context.getBeatsPerMeasure();
        double amplitude = 1.0;
        while (timeLeft > 0.0) {
            System.out.println("add chord, measureDuration = " + measureDuration + ", timeLeft = " + timeLeft + ", amplitude = " + amplitude);
            Column chord = new Column();
            int i = 0;
            while (i < this.context.chordScale.size()) {
                int pitch = this.context.chordScale.get(i);
                ScoreNote note = new ScoreNote(duration, pitch);
                chord.add(note);
                ++i;
            }
            chord.setAmplitude(amplitude);
            amplitude *= 0.7;
            sequence.add(chord);
            timeLeft -= duration;
        }
        return sequence;
    }

    @Override
    public void setDensity(double value) {
    }

    @Override
    public void setScale(Scale scale) {
        this.context.scale = scale;
    }

    @Override
    public void setChordProgression(ChordProgression chordProgression) {
        this.chordProgression = chordProgression;
    }
}

