/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.score;

public abstract class ScoreClock {
    private double timeScale = 1.0;
    private double realTimeBase;
    private double scoreTimeBase;

    public abstract double getRealTime();

    public abstract void sleepUntilRealTime(double var1) throws InterruptedException;

    public void reset(double advance) {
        this.realTimeBase = this.getRealTime() + advance;
        this.scoreTimeBase = 0.0;
    }

    public void reset() {
        this.reset(0.0);
    }

    public synchronized double convertRealTimeToScoreTime(double realTime) {
        return (realTime - this.realTimeBase) * this.timeScale + this.scoreTimeBase;
    }

    public synchronized double convertScoreTimeToRealTime(double scoreTime) {
        return (scoreTime - this.scoreTimeBase) / this.timeScale + this.realTimeBase;
    }

    public void sleepUntilScoreTime(double scoreTime) throws InterruptedException {
        this.sleepUntilRealTime(this.convertScoreTimeToRealTime(scoreTime));
    }

    public synchronized double getScoreTime() {
        return this.convertRealTimeToScoreTime(this.getRealTime());
    }

    public synchronized void setTimeScale(double timeScale) {
        double realTime = this.getRealTime();
        this.scoreTimeBase = this.convertRealTimeToScoreTime(realTime);
        this.timeScale = timeScale;
        this.realTimeBase = realTime;
    }

    public double getTimeScale() {
        return this.timeScale;
    }
}

