/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JPanel;

public class BooleanBox
extends JPanel {
    private boolean selected;
    private CopyOnWriteArrayList<ActionListener> actionListeners = new CopyOnWriteArrayList();
    private static final int WIDTH = 20;
    private static final int HEIGHT = 20;
    private static final int MARGIN = 4;

    public BooleanBox() {
        this.addMouseListener(new MyMouseListener());
        Dimension dim = new Dimension(20, 20);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
    }

    @Override
    public void paintComponent(Graphics g) {
        int diameter;
        super.paintComponent(g);
        int x = 2;
        int y = 2;
        int w = this.getWidth() - 4;
        int h = this.getHeight() - 4;
        int n = diameter = w < h ? w : h;
        if (this.selected) {
            g.setColor(Color.CYAN);
            g.fillOval(x, y, diameter, diameter);
        }
        g.setColor(Color.BLACK);
        g.drawOval(x, y, diameter, diameter);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    public void fireActionListeners() {
        ActionEvent event = new ActionEvent(this, 1001, "toggle");
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(event);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            BooleanBox.this.setSelected(!BooleanBox.this.isSelected());
            BooleanBox.this.fireActionListeners();
        }
    }
}

