/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import com.syntona.gui.patch.PlayOverrideFocusListener;
import com.syntona.plugin.InputDoubleJack;
import com.syntona.plugin.JTextFieldDouble;
import com.syntona.plugin.JackEditor;
import com.syntona.plugin.ModulePresenter;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InputDoubleJackEditor
implements JackEditor {
    private InputDoubleJack jack;
    private JPanel panel;
    private JSlider slider;
    private JPanel fieldPanel;
    private JTextFieldDouble minField;
    private JTextFieldDouble valueField;
    private JTextFieldDouble maxField;
    private ModulePresenter modulePresenter;

    public InputDoubleJackEditor(InputDoubleJack jack, ModulePresenter modulePresenter) {
        this.jack = jack;
        this.modulePresenter = modulePresenter;
        this.panel = new JPanel();
        GridLayout layout = new GridLayout(2, 1);
        this.panel.setLayout(layout);
        this.setupFields();
        this.setupSlider();
    }

    private void setupSlider() {
        this.slider = new JSlider(0);
        BoundedRangeModel rangeModel = this.jack.getBoundedRangeModel();
        this.slider.setModel(rangeModel);
        this.slider.setSize(100, 20);
        this.panel.add(this.slider);
        String title = this.jack.getName();
        this.panel.setBorder(BorderFactory.createTitledBorder(title));
        rangeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InputDoubleJackEditor.this.valueField.setValue(InputDoubleJackEditor.this.jack.getValue());
                InputDoubleJackEditor.this.modulePresenter.markDirty();
            }
        });
    }

    private void setupFields() {
        this.fieldPanel = new JPanel();
        this.panel.add(this.fieldPanel);
        this.fieldPanel.add(new JLabel("Min:"));
        this.minField = new JTextFieldDouble(this.jack.getMin(), 8);
        this.fieldPanel.add(this.minField);
        this.minField.addFocusListener(new PlayOverrideFocusListener());
        this.fieldPanel.add(new JLabel("Value:"));
        this.valueField = new JTextFieldDouble(this.jack.getValue(), 8);
        this.fieldPanel.add(this.valueField);
        this.valueField.addFocusListener(new PlayOverrideFocusListener());
        this.fieldPanel.add(new JLabel("Max:"));
        this.maxField = new JTextFieldDouble(this.jack.getMax(), 8);
        this.fieldPanel.add(this.maxField);
        this.maxField.addFocusListener(new PlayOverrideFocusListener());
        this.minField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    double newMin = InputDoubleJackEditor.this.minField.getValue();
                    double max = InputDoubleJackEditor.this.jack.getMax();
                    if (newMin >= max) {
                        newMin = 0.99 * max;
                        InputDoubleJackEditor.this.minField.setValue(newMin);
                    }
                    InputDoubleJackEditor.this.jack.setMin(newMin);
                    InputDoubleJackEditor.this.clipAndSetValue(InputDoubleJackEditor.this.jack.getValue());
                }
                catch (NumberFormatException e) {
                    InputDoubleJackEditor.this.minField.setText("Error!");
                    InputDoubleJackEditor.this.minField.selectAll();
                }
            }
        });
        this.valueField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    double value = InputDoubleJackEditor.this.valueField.getValue();
                    InputDoubleJackEditor.this.clipAndSetValue(value);
                }
                catch (NumberFormatException e) {
                    InputDoubleJackEditor.this.valueField.setText("Error!");
                    InputDoubleJackEditor.this.valueField.selectAll();
                }
            }
        });
        this.maxField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    double newMax = InputDoubleJackEditor.this.maxField.getValue();
                    double min = InputDoubleJackEditor.this.jack.getMin();
                    if (newMax <= min) {
                        newMax = 1.01 * min;
                        InputDoubleJackEditor.this.maxField.setValue(newMax);
                    }
                    InputDoubleJackEditor.this.jack.setMax(newMax);
                    InputDoubleJackEditor.this.clipAndSetValue(InputDoubleJackEditor.this.jack.getValue());
                }
                catch (NumberFormatException e) {
                    InputDoubleJackEditor.this.maxField.setText("Error!");
                    InputDoubleJackEditor.this.maxField.selectAll();
                }
            }
        });
    }

    public JPanel getFieldPanel() {
        return this.fieldPanel;
    }

    protected void clipAndSetValue(double value) {
        if (value > this.jack.getMax()) {
            value = this.jack.getMax();
        }
        if (value < this.jack.getMin()) {
            value = this.jack.getMin();
        }
        this.jack.setValue(value);
        this.jack.kick();
        this.modulePresenter.markDirty();
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }
}

