/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.ports.QueueDataCommand;
import com.jsyn.ports.UnitDataQueuePort;
import com.jsyn.ports.UnitPort;
import com.syntona.model.jsyn.AudioJack;
import com.syntona.model.jsyn.DataQueueOutputJack;
import com.syntona.model.jsyn.PatchMessageQueueCommand;
import com.syntona.plugin.InputJack;
import com.syntona.plugin.Jack;
import com.syntona.plugin.PatchMessage;
import com.syntona.plugin.SyntonaModule;
import java.awt.Color;

public class DataQueueInputJack
extends InputJack
implements AudioJack {
    private static Color SIGNAL_COLOR = new Color(180, 180, 0);
    private static Color JACK_COLOR = new Color(255, 255, 100);
    private UnitDataQueuePort dataQueuePort;

    public DataQueueInputJack(SyntonaModule module, String name, String help) {
        super(module, name, help);
    }

    public DataQueueInputJack(SyntonaModule module, String name, UnitDataQueuePort port) {
        super(module, name, name);
        this.dataQueuePort = port;
    }

    @Override
    public Color getColor() {
        return JACK_COLOR;
    }

    @Override
    public Color getSignalColor() {
        return SIGNAL_COLOR;
    }

    @Override
    public boolean willAccept(Jack other) {
        return super.willAccept(other) && other instanceof DataQueueOutputJack;
    }

    @Override
    public void setPartIndex(int j) {
    }

    @Override
    public UnitPort getSynthPort() {
        return this.dataQueuePort;
    }

    @Override
    public int getPartIndex() {
        return 0;
    }

    @Override
    public void passMessage(PatchMessage msg) {
        super.passMessage(msg);
        PatchMessageQueueCommand queueCommand = (PatchMessageQueueCommand)msg;
        if (queueCommand.getCommand() == 0) {
            this.dataQueuePort.queueOn(queueCommand.getQueueableData());
        } else if (queueCommand.getCommand() == 1) {
            this.dataQueuePort.queueOff(queueCommand.getQueueableData());
        } else if (queueCommand.getCommand() == 2) {
            QueueDataCommand command = this.dataQueuePort.createQueueDataCommand(queueCommand.getQueueableData());
            command.setImmediate(queueCommand.isImmediate());
            this.dataQueuePort.queueCommand(command);
        }
    }
}

