/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.midi;

import com.syntona.model.midi.ControlInModule;
import com.syntona.model.midi.MidiEngine;
import com.syntona.model.midi.MidiToolBar;
import com.syntona.model.midi.NoteOffInModule;
import com.syntona.model.midi.NoteOnInModule;
import com.syntona.plugin.Bundle;
import java.util.logging.Logger;
import javax.swing.JToolBar;

public class MidiBundle
extends Bundle {
    protected static final String JSYN_JAVADOCS_URL_PREFIX = "http://www.softsynth.com/jsyn/docs/javadocs/";
    private static Logger logger = Logger.getLogger(MidiBundle.class.getName());
    private static MidiBundle instance = null;
    private static String GROUP_INPUT = "input";
    private JToolBar toolbar;
    private MidiEngine mMidiEngine = MidiEngine.getInstance();

    public static MidiBundle getInstance() {
        if (instance == null) {
            instance = new MidiBundle();
        }
        return instance;
    }

    @Override
    public String getName() {
        return "midi";
    }

    @Override
    public void addClasses() {
        this.addModule(GROUP_INPUT, "noteOnIn", NoteOnInModule.class);
        this.addModule(GROUP_INPUT, "noteOffIn", NoteOffInModule.class);
        this.addModule(GROUP_INPUT, "ctrlIn", ControlInModule.class);
    }

    @Override
    public void start() {
        this.mMidiEngine.start();
    }

    @Override
    public void stop() {
        this.mMidiEngine.stop();
    }

    @Override
    public JToolBar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new MidiToolBar();
        }
        return this.toolbar;
    }

    protected static String createJSynHelp(Class<?> moduleClass) {
        String className = moduleClass.getName();
        String classWithSlashes = className.replace('.', '/');
        String webpageName = JSYN_JAVADOCS_URL_PREFIX + classWithSlashes + ".html";
        return webpageName;
    }
}

