/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.midi;

import com.jsyn.devices.javasound.MidiDeviceTools;
import com.jsyn.midi.MessageParser;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;

public class MidiEngine {
    private static MidiEngine instance;
    private CopyOnWriteArrayList<NoteReceiver> mNoteOnReceivers = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<NoteReceiver> mNoteOffReceivers = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<ControlChangeReceiver> mControlChangeReceivers = new CopyOnWriteArrayList();
    private EngineParser mParser = new EngineParser();

    public static MidiEngine getInstance() {
        if (instance == null) {
            instance = new MidiEngine();
        }
        return instance;
    }

    public void start() {
        try {
            MidiDevice keyboard = MidiDeviceTools.findKeyboard();
            EngineReceiver receiver = new EngineReceiver();
            if (keyboard != null) {
                keyboard.open();
                keyboard.getTransmitter().setReceiver(receiver);
                System.out.println("Found MIDI keyboard: " + keyboard.getDeviceInfo().getDescription());
            } else {
                System.out.println("Could not find a keyboard.");
            }
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    public void addNoteOnReceiver(NoteReceiver receiver) {
        this.mNoteOnReceivers.add(receiver);
    }

    public void addNoteOffReceiver(NoteReceiver receiver) {
        this.mNoteOffReceivers.add(receiver);
    }

    public void addControlChangeReceiver(ControlChangeReceiver receiver) {
        this.mControlChangeReceivers.add(receiver);
    }

    public static interface ControlChangeReceiver {
        public void onControlChange(int var1, int var2, int var3);
    }

    private class EngineParser
    extends MessageParser {
        private EngineParser() {
        }

        @Override
        public void noteOn(int channel, int pitch, int velocity) {
            for (NoteReceiver receiver : MidiEngine.this.mNoteOnReceivers) {
                receiver.onNote(channel, pitch, velocity);
            }
        }

        @Override
        public void noteOff(int channel, int pitch, int velocity) {
            for (NoteReceiver receiver : MidiEngine.this.mNoteOffReceivers) {
                receiver.onNote(channel, pitch, velocity);
            }
        }

        @Override
        public void controlChange(int channel, int index, int value) {
            for (ControlChangeReceiver receiver : MidiEngine.this.mControlChangeReceivers) {
                receiver.onControlChange(channel, index, value);
            }
        }
    }

    private class EngineReceiver
    implements Receiver {
        private EngineReceiver() {
        }

        @Override
        public void send(MidiMessage message, long timeStamp) {
            byte[] bytes = message.getMessage();
            MidiEngine.this.mParser.parse(bytes);
        }

        @Override
        public void close() {
        }
    }

    public static interface NoteReceiver {
        public void onNote(int var1, int var2, int var3);
    }
}

