/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.data;

import com.jsyn.data.AudioSample;
import com.jsyn.engine.SynthesisEngine;

public class ShortSample
extends AudioSample {
    private short[] buffer;

    public ShortSample() {
    }

    public ShortSample(int numFrames, int channelsPerFrame) {
        this.allocate(numFrames, channelsPerFrame);
    }

    public ShortSample(short[] data) {
        this(data.length, 1);
        this.write(data);
    }

    public ShortSample(short[] data, int channelsPerFrame) {
        this(data.length / channelsPerFrame, channelsPerFrame);
        this.write(data);
    }

    @Override
    public void allocate(int numFrames, int channelsPerFrame) {
        this.buffer = new short[numFrames * channelsPerFrame];
        this.numFrames = numFrames;
        this.channelsPerFrame = channelsPerFrame;
    }

    public void write(int startFrame, short[] data, int startIndex, int numFrames) {
        int numSamplesToWrite = numFrames * this.channelsPerFrame;
        int firstSampleIndexToWrite = startFrame * this.channelsPerFrame;
        System.arraycopy(data, startIndex, this.buffer, firstSampleIndexToWrite, numSamplesToWrite);
    }

    public void read(int startFrame, short[] data, int startIndex, int numFrames) {
        int numSamplesToRead = numFrames * this.channelsPerFrame;
        int firstSampleIndexToRead = startFrame * this.channelsPerFrame;
        System.arraycopy(this.buffer, firstSampleIndexToRead, data, startIndex, numSamplesToRead);
    }

    public void write(short[] data) {
        this.write(0, data, 0, data.length);
    }

    public void read(short[] data) {
        this.read(0, data, 0, data.length);
    }

    public short readShort(int index) {
        return this.buffer[index];
    }

    public void writeShort(int index, short value) {
        this.buffer[index] = value;
    }

    @Override
    public double readDouble(int index) {
        return SynthesisEngine.convertShortToDouble(this.buffer[index]);
    }

    @Override
    public void writeDouble(int index, double value) {
        this.buffer[index] = SynthesisEngine.convertDoubleToShort(value);
    }
}

