/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.SineOscillator;

public class SineOscillatorPhaseModulated
extends SineOscillator {
    public UnitInputPort modulation = new UnitInputPort("Modulation");

    public SineOscillatorPhaseModulated() {
        this.addPort(this.modulation);
    }

    @Override
    public void generate(int start, int limit) {
        double[] frequencies = this.frequency.getValues();
        double[] amplitudes = this.amplitude.getValues();
        double[] outputs = this.output.getValues();
        double[] modulations = this.modulation.getValues();
        double currentPhase = this.phase.getValue();
        int i = start;
        while (i < limit) {
            double phaseIncrement = this.convertFrequencyToPhaseIncrement(frequencies[i]);
            currentPhase = this.incrementWrapPhase(currentPhase, phaseIncrement);
            double modulatedPhase = currentPhase + modulations[i];
            double value = Math.sin(modulatedPhase * Math.PI);
            outputs[i] = value * amplitudes[i];
            ++i;
        }
        this.phase.setValue(currentPhase);
    }
}

