/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.unitgen.Add;
import com.jsyn.unitgen.EnablingGate;
import com.jsyn.unitgen.LinearRamp;
import junit.framework.TestCase;

public class TestEnable
extends TestCase {
    SynthesisEngine synthesisEngine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.synthesisEngine = new SynthesisEngine();
        this.synthesisEngine.setRealTime(false);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.synthesisEngine.stop();
    }

    public void testEnablingGate() throws InterruptedException {
        LinearRamp ramp = new LinearRamp();
        this.synthesisEngine.add(ramp);
        EnablingGate enabler = new EnablingGate();
        this.synthesisEngine.add(enabler);
        Add adder = new Add();
        this.synthesisEngine.add(adder);
        ramp.output.connect(enabler.input);
        enabler.output.connect(adder.inputA);
        ramp.current.set(0.0);
        ramp.input.set(1.0);
        ramp.time.set(1.0);
        enabler.gate.set(1.0);
        this.synthesisEngine.start();
        double startTime = this.synthesisEngine.getCurrentTime();
        adder.start();
        this.synthesisEngine.sleepUntil(startTime + 0.1);
        double tolerance = 0.002;
        TestEnable.assertEquals("ramp going up", 0.1, ramp.output.getValue(), tolerance);
        TestEnable.assertEquals("enabler going up", 0.1, enabler.output.getValue(), tolerance);
        TestEnable.assertEquals("adder going up", 0.1, adder.output.getValue(), tolerance);
        this.synthesisEngine.sleepUntil(startTime + 0.2);
        TestEnable.assertEquals("start enabled", 0.2, adder.output.getValue(), tolerance);
        enabler.gate.set(0.0);
        this.synthesisEngine.sleepUntil(startTime + 0.3);
        TestEnable.assertEquals("should not be pulled", 0.2, ramp.output.getValue(), tolerance);
        TestEnable.assertEquals("should be disabled", false, enabler.isEnabled());
        TestEnable.assertEquals("should be zero", 0.0, enabler.output.getValue(), tolerance);
        TestEnable.assertEquals("zero", 0.0, adder.output.getValue(), tolerance);
    }
}

