/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.core;

import com.syntona.model.SyntonaEngine;
import com.syntona.model.core.AddModule;
import com.syntona.model.core.CoreBundle;
import com.syntona.model.core.DoubleValueModule;
import com.syntona.model.core.PatchModulePresenter;
import com.syntona.model.jsyn.JSynBundle;
import com.syntona.plugin.Bundle;
import com.syntona.plugin.InputDoubleJack;
import com.syntona.plugin.InputJack;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.OutputDoubleJack;
import com.syntona.plugin.PatchMessageDouble;
import com.syntona.plugin.SyntonaModule;
import junit.framework.TestCase;

public class TestModules
extends TestCase {
    private SyntonaEngine engine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.engine = SyntonaEngine.getInstance();
        this.engine.start();
    }

    @Override
    protected void tearDown() throws Exception {
        this.engine.stop();
        super.tearDown();
    }

    public void testCompareModule() {
        CoreBundle bundle = (CoreBundle)CoreBundle.getInstance();
        this.checkModuleDetails(bundle, "compare");
    }

    private void checkModuleDetails(Bundle bundle, String type) {
        ModulePresenter presenter = bundle.createModule(type, null);
        TestModules.assertTrue("Check presenter", presenter != null);
        TestModules.assertTrue("Check view ", presenter.getView() != null);
        TestModules.assertTrue("Check module", presenter.getModule() != null);
        SyntonaModule module = presenter.getModule();
        TestModules.assertEquals("module type", type, module.getType());
    }

    public void testFaderModule() {
        CoreBundle bundle = (CoreBundle)CoreBundle.getInstance();
        this.checkModuleDetails(bundle, "fader");
    }

    public void testJSynLineOut() {
        JSynBundle bundle = JSynBundle.getInstance();
        this.checkModuleDetails(bundle, "lineOut");
    }

    public void testSimpleAdd() {
        PatchModulePresenter topPatch = this.engine.getTopPatches()[0];
        this.engine.sendAddModule(CoreBundle.getInstance(), topPatch, "fader");
        this.engine.sendAddModule(CoreBundle.getInstance(), topPatch, "+");
        this.drainCommandQueue(1000L);
        SyntonaModule[] modules = topPatch.getPatchModule().getModules();
        TestModules.assertEquals("two modules", 2, modules.length);
        SyntonaModule doubleValueModel = null;
        AddModule addModule = null;
        SyntonaModule[] syntonaModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            SyntonaModule module = syntonaModuleArray[n2];
            if (module instanceof DoubleValueModule) {
                doubleValueModel = (DoubleValueModule)module;
            }
            if (module instanceof AddModule) {
                addModule = (AddModule)module;
            }
            ++n2;
        }
        InputDoubleJack setter = (InputDoubleJack)doubleValueModel.getJackByName("in");
        TestModules.assertTrue("Got in jack", setter != null);
        InputJack kicker = (InputJack)doubleValueModel.getJackByName("kick");
        TestModules.assertTrue("Got kick jack", kicker != null);
        OutputDoubleJack conOut = (OutputDoubleJack)doubleValueModel.getJackByName("out");
        InputJack A = (InputJack)addModule.getJackByName("A");
        InputDoubleJack B = (InputDoubleJack)addModule.getJackByName("B");
        OutputDoubleJack addOut = (OutputDoubleJack)addModule.getJackByName("out");
        conOut.connect(A);
        PatchMessageDouble msg1 = new PatchMessageDouble(23.0);
        setter.passMessage(msg1);
        TestModules.assertTrue("Check setter of NoteGeneratorModel", Math.round(setter.getValue()) == 23L);
        PatchMessageDouble msg2 = new PatchMessageDouble(100.0);
        B.passMessage(msg2);
        TestModules.assertTrue("Check B of AddModel", Math.round(B.getValue()) == 100L);
        PatchMessageDouble msg3 = new PatchMessageDouble(0.0);
        kicker.passMessage(msg3);
        double sum = addOut.getValue();
        System.out.println("sum = " + sum);
        TestModules.assertTrue("Check output of AddModel = " + sum, Math.round(addOut.getValue()) == 123L);
    }

    private void drainCommandQueue(long msec) {
        long timeout = -1L;
        try {
            timeout = this.engine.drainCommandQueue(msec);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TestModules.assertTrue("Check drain timeout = " + timeout, timeout > 0L);
    }
}

