/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.ports.UnitDataQueuePort;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitPort;
import com.jsyn.unitgen.UnitGenerator;
import com.syntona.model.jsyn.AudioJack;
import com.syntona.model.jsyn.DataQueueInputJack;
import com.syntona.model.jsyn.InputAudioJack;
import com.syntona.model.jsyn.JSynBundle;
import com.syntona.model.jsyn.ObjectExaminer;
import com.syntona.model.jsyn.OutputAudioJack;
import com.syntona.model.jsyn.UnitGenModule;
import com.syntona.plugin.SyntonaModule;

public class GenericUnitModule
extends UnitGenModule {
    @Override
    public void setup(UnitGenerator sound) {
        super.setup(sound);
        JSynBundle.getSynthesizer().add(sound);
        this.setupJacks();
        this.setHelp(sound.getClass().getName());
    }

    public void setupJacks() {
        this.scanPortsMakeJacks(false);
        this.scanPortsMakeJacks(true);
    }

    private void scanPortsMakeJacks(boolean doOutputs) {
        for (UnitPort port : this.ugen.getPorts()) {
            AudioJack wjack = null;
            String fieldName = ObjectExaminer.findFieldName(this.ugen, port);
            int j = 0;
            while (j < port.getNumParts()) {
                String jackName = fieldName;
                if (port.getNumParts() > 1) {
                    jackName = String.valueOf(jackName) + j;
                }
                if ((wjack = !doOutputs && port instanceof UnitInputPort ? new InputAudioJack(this, jackName, (UnitInputPort)port, j) : (doOutputs && port instanceof UnitOutputPort ? new OutputAudioJack((SyntonaModule)this, jackName, (UnitOutputPort)port) : (!doOutputs && port instanceof UnitDataQueuePort ? new DataQueueInputJack((SyntonaModule)this, jackName, (UnitDataQueuePort)port) : null))) != null) {
                    wjack.setPartIndex(j);
                }
                ++j;
            }
        }
    }
}

