/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.midi;

import com.jsyn.devices.javasound.MidiDeviceTools;
import java.io.IOException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;

public class TestMidiLoop {
    public static void main(String[] args) {
        TestMidiLoop app = new TestMidiLoop();
        int result = 0;
        try {
            int i = 0;
            while (i < 3 && result == 0) {
                result = app.test();
                ++i;
            }
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.print("Test finished.");
        System.exit(result == 0 ? 0 : 1);
    }

    public int test() throws MidiUnavailableException, IOException, InterruptedException {
        int result = -1;
        MidiDevice keyboard = MidiDeviceTools.findKeyboard();
        CustomReceiver receiver = new CustomReceiver();
        if (keyboard != null) {
            keyboard.open();
            keyboard.getTransmitter().setReceiver(receiver);
            System.out.println("Play MIDI keyboard: " + keyboard.getDeviceInfo().getDescription());
            result = 0;
            Thread.sleep(4000L);
            System.out.println("Close the keyboard. It may not work after this according to the docs!");
            keyboard.close();
        } else {
            System.out.println("Could not find a keyboard.");
        }
        return result;
    }

    class CustomReceiver
    implements Receiver {
        CustomReceiver() {
        }

        @Override
        public void close() {
            System.out.print("Receiver.close() was called.");
        }

        @Override
        public void send(MidiMessage message, long timeStamp) {
            byte[] bytes = message.getMessage();
            System.out.println("Got " + bytes.length + " bytes.");
        }
    }
}

