/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.swing.DoubleBoundedRangeModel;
import junit.framework.TestCase;

public class TestRangeModels
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void checkDoubleRange(double dmin, double dmax, double dval) {
        int resolution = 1000;
        DoubleBoundedRangeModel model = new DoubleBoundedRangeModel("test", resolution, dmin, dmax, dval);
        TestRangeModels.assertEquals((String)"setup min", (double)dmin, (double)model.getDoubleMinimum(), (double)1.0E-4);
        TestRangeModels.assertEquals((String)"setup max", (double)dmax, (double)model.getDoubleMaximum(), (double)1.0E-4);
        TestRangeModels.assertEquals((String)"setup value", (double)dval, (double)model.getDoubleValue(), (double)1.0E-4);
        model.setDoubleValue(dmin);
        TestRangeModels.assertEquals((String)"min double value", (double)dmin, (double)model.getDoubleValue(), (double)1.0E-4);
        TestRangeModels.assertEquals((String)"min value", (int)0, (int)model.getValue());
        double dmid = (dmax + dmin) / 2.0;
        model.setDoubleValue(dmid);
        TestRangeModels.assertEquals((String)"middle double value", (double)dmid, (double)model.getDoubleValue(), (double)1.0E-4);
        TestRangeModels.assertEquals((String)"middle value", (int)(resolution / 2), (int)model.getValue());
        model.setDoubleValue(dmax);
        TestRangeModels.assertEquals((String)"max double value", (double)dmax, (double)model.getDoubleValue(), (double)1.0E-4);
        TestRangeModels.assertEquals((String)"max value", (int)resolution, (int)model.getValue());
    }

    public void testDoubleRange() {
        this.checkDoubleRange(10.0, 20.0, 12.0);
        this.checkDoubleRange(-1.0, 1.0, 0.5);
    }
}

