/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.data.Spectrum;
import com.jsyn.ports.UnitSpectralInputPort;
import com.jsyn.ports.UnitSpectralOutputPort;
import com.jsyn.unitgen.UnitGenerator;

public abstract class SpectralProcessor
extends UnitGenerator {
    public UnitSpectralInputPort input;
    public UnitSpectralOutputPort output;
    private int counter;

    public SpectralProcessor() {
        this.output = new UnitSpectralOutputPort();
        this.addPort(this.output);
        this.input = new UnitSpectralInputPort();
        this.addPort(this.input);
    }

    public SpectralProcessor(int size) {
        this.output = new UnitSpectralOutputPort(size);
        this.addPort(this.output);
        this.input = new UnitSpectralInputPort();
        this.addPort(this.input);
    }

    @Override
    public void generate(int start, int limit) {
        int i = start;
        while (i < limit) {
            if (this.counter == 0) {
                if (this.input.isAvailable()) {
                    Spectrum inputSpectrum = this.input.getSpectrum();
                    Spectrum outputSpectrum = this.output.getSpectrum();
                    this.processSpectrum(inputSpectrum, outputSpectrum);
                    this.output.advance();
                    this.counter = inputSpectrum.size() - 1;
                }
            } else {
                --this.counter;
            }
            ++i;
        }
    }

    public abstract void processSpectrum(Spectrum var1, Spectrum var2);
}

