/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.debug;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class TestKeyDispatch {
    private JFrame mFrame;
    private JLabel mText;
    private HashSet<Character> mActiveKeys = new HashSet();
    KeyEventDispatcher keyEventDispatcher = new KeyEventDispatcher(){

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            boolean handled = false;
            System.out.println("dispatchKeyEvent: " + e);
            if (e.getID() == 401) {
                TestKeyDispatch.this.mActiveKeys.add(Character.valueOf(e.getKeyChar()));
                TestKeyDispatch.this.updateKeyView();
            } else if (e.getID() == 402) {
                TestKeyDispatch.this.mActiveKeys.remove(Character.valueOf(e.getKeyChar()));
                TestKeyDispatch.this.updateKeyView();
            }
            return handled;
        }
    };

    public void test() {
        this.mFrame = new JFrame("Test KeyDispatch");
        this.mFrame.setSize(300, 200);
        this.mFrame.setDefaultCloseOperation(3);
        this.mText = new JLabel("");
        this.updateKeyView();
        this.mFrame.getContentPane().add(this.mText);
        this.mFrame.setVisible(true);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
    }

    protected void updateKeyView() {
        String msg = "keys = ";
        for (Character c : this.mActiveKeys) {
            msg = String.valueOf(msg) + c;
        }
        this.mText.setText(msg);
    }

    public static void main(String[] args) {
        new TestKeyDispatch().test();
    }
}

