/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.core;

import com.syntona.gui.patch.ModuleEditor;
import com.syntona.gui.patch.ModuleView;
import com.syntona.model.core.KeyMatchModule;
import com.syntona.model.core.KeyMatchModuleView;
import com.syntona.model.core.PlayKeyModulePresenter;
import com.syntona.plugin.Jack;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.MaskFormatter;

public class KeyMatchModulePresenter
extends PlayKeyModulePresenter {
    private KeyMatchModule keyMatchModule;
    private KeyMatchModuleView keyMatchModuleView = new KeyMatchModuleView(this);

    public KeyMatchModulePresenter() {
        super(new KeyMatchModule("Send key if matches to \"on\" or \"off\" jack."));
        this.setView(this.keyMatchModuleView);
        this.keyMatchModule = (KeyMatchModule)this.getModule();
    }

    @Override
    public void keyOn(char key) {
        if (key == this.keyMatchModule.getKey()) {
            this.sendOnMessage(key);
        }
    }

    @Override
    public void keyOff(char key) {
        if (key == this.keyMatchModule.getKey()) {
            this.sendOffMessage(key);
        }
    }

    private MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            System.err.println("formatter is bad: " + exc.getMessage());
        }
        return formatter;
    }

    @Override
    public ModuleEditor createModuleEditor() {
        return new KeyMatchModuleEditor(this.getView());
    }

    private class KeyMatchModuleEditor
    extends ModuleEditor
    implements PropertyChangeListener {
        JFormattedTextField textField;

        public KeyMatchModuleEditor(ModuleView moduleView) {
            super(moduleView);
        }

        @Override
        public Component setupJackEditors(ModuleView moduleView, Jack[] jacks) {
            JPanel topPanel = new JPanel();
            topPanel.add(new JLabel("Enter letter or digit to match:"));
            this.textField = new JFormattedTextField(KeyMatchModulePresenter.this.createFormatter("A"));
            this.textField.setValue("" + KeyMatchModulePresenter.this.keyMatchModule.getKey());
            this.textField.setColumns(1);
            this.textField.addPropertyChangeListener("value", this);
            this.textField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    char key = e.getKeyChar();
                    if (Character.isLetterOrDigit(key = Character.toUpperCase(key))) {
                        KeyMatchModuleEditor.this.textField.setValue("");
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
            topPanel.add(this.textField);
            return topPanel;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String text = this.textField.getText().trim();
            if (text.length() > 0) {
                char key = text.charAt(0);
                key = Character.toUpperCase(key);
                KeyMatchModulePresenter.this.keyMatchModule.setKey(key);
                KeyMatchModulePresenter.this.keyMatchModuleView.setKey(key);
            }
        }
    }
}

