/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.core;

import com.syntona.plugin.InputActionJack;
import com.syntona.plugin.InputDoubleJack;
import com.syntona.plugin.OutputDoubleJack;
import com.syntona.plugin.SyntonaModule;

public class SequenceKnobModule
extends SyntonaModule {
    private InputActionJack reset;
    private InputActionJack clock;
    protected InputDoubleJack[] inputs;
    protected OutputDoubleJack[] outputs;
    protected OutputDoubleJack output;
    private int counter;
    protected int length;

    public SequenceKnobModule(int length) {
        super("Send knob value to sequential outputs.");
        this.length = length;
        this.clock = new InputActionJack(this, "clock", "Advance sequence."){

            @Override
            public void execute() {
            }
        };
        this.clock.setKickable(true);
        this.reset = new InputActionJack(this, "reset", "Reset sequence back to zero."){

            @Override
            public void execute() {
                SequenceKnobModule.this.counter = 0;
            }
        };
        this.inputs = new InputDoubleJack[length];
        int i = 0;
        while (i < this.inputs.length) {
            this.inputs[i] = new InputDoubleJack(this, "in" + i);
            this.inputs[i].setViewType(2);
            ++i;
        }
        this.outputs = new OutputDoubleJack[length];
        i = 0;
        while (i < this.outputs.length) {
            this.outputs[i] = new OutputDoubleJack(this, "out" + i);
            this.outputs[i].setVisible(false);
            this.outputs[i].setLevelWith(this.inputs[i]);
            ++i;
        }
        this.output = new OutputDoubleJack(this, "output");
    }

    @Override
    public void kick() {
        int cnt = this.counter++;
        if (this.counter >= this.length) {
            this.counter = 0;
        }
        InputDoubleJack in = this.inputs[cnt];
        OutputDoubleJack out = this.outputs[cnt];
        this.changeActiveJack(in);
        this.passDoubleMessage(in.getValue(), out);
        this.passDoubleMessage(in.getValue(), this.output);
    }
}

