/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.SpectralFFT;
import com.jsyn.unitgen.SpectralIFFT;
import com.jsyn.unitgen.UnitOscillator;

public class FFTPassthrough {
    private Synthesizer synth;
    private PassThrough center;
    private UnitOscillator osc;
    private UnitOscillator lfo;
    private SpectralFFT fft;
    private SpectralIFFT ifft1;
    private LineOut lineOut;
    private SpectralIFFT ifft2;

    private void test() {
        this.synth = JSyn.createSynthesizer();
        this.synth.start();
        this.center = new PassThrough();
        this.synth.add(this.center);
        this.osc = new SineOscillator();
        this.synth.add(this.osc);
        this.lfo = new SineOscillator();
        this.synth.add(this.lfo);
        this.fft = new SpectralFFT();
        this.synth.add(this.fft);
        this.ifft1 = new SpectralIFFT();
        this.synth.add(this.ifft1);
        this.ifft2 = new SpectralIFFT();
        this.synth.add(this.ifft2);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.center.output.connect(this.osc.frequency);
        this.lfo.output.connect(this.osc.frequency);
        this.osc.output.connect(this.fft.input);
        this.fft.output.connect(this.ifft1.input);
        this.fft.output.connect(this.ifft2.input);
        this.ifft1.output.connect(0, this.lineOut.input, 0);
        this.ifft2.output.connect(0, this.lineOut.input, 1);
        this.center.input.set(600.0);
        this.lfo.frequency.set(0.2);
        this.lfo.amplitude.set(400.0);
        this.osc.amplitude.set(0.6);
        this.lineOut.start();
        System.out.println("You should now be hearing a clean oscillator on the left channel,");
        System.out.println("and the FFT->IFFT processed signal on the right channel.");
        try {
            double time = this.synth.getCurrentTime();
            this.synth.sleepUntil(time + 20.0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Stop playing. -------------------");
        this.synth.stop();
    }

    public static void main(String[] args) {
        new FFTPassthrough().test();
    }
}

