/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.swing.ExponentialRangeModel;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.swing.PortModelFactory;
import com.jsyn.swing.RotaryTextController;
import com.jsyn.unitgen.EnvelopeDAHDSR;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.SquareOscillator;
import com.jsyn.unitgen.UnitOscillator;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JApplet;

public class HearDAHDSR
extends JApplet {
    private Synthesizer synth;
    private UnitOscillator osc;
    private UnitOscillator gatingOsc;
    private EnvelopeDAHDSR dahdsr;
    private LineOut lineOut;

    @Override
    public void init() {
        this.synth = JSyn.createSynthesizer();
        this.osc = new SineOscillator();
        this.synth.add(this.osc);
        this.gatingOsc = new SquareOscillator();
        this.synth.add(this.gatingOsc);
        this.dahdsr = new EnvelopeDAHDSR();
        this.synth.add(this.dahdsr);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.gatingOsc.output.connect(this.dahdsr.input);
        this.dahdsr.output.connect(this.osc.amplitude);
        this.dahdsr.attack.setup(0.001, 0.01, 2.0);
        this.osc.output.connect(0, this.lineOut.input, 0);
        this.osc.output.connect(0, this.lineOut.input, 1);
        this.gatingOsc.frequency.setup(0.001, 0.5, 10.0);
        this.gatingOsc.frequency.setName("Rate");
        this.osc.frequency.setup(50.0, 440.0, 2000.0);
        this.osc.frequency.setName("Freq");
        this.setLayout(new GridLayout(1, 0));
        this.setupPortKnob(this.osc.frequency);
        this.setupPortKnob(this.gatingOsc.frequency);
        this.setupPortKnob(this.dahdsr.attack);
        this.setupPortKnob(this.dahdsr.hold);
        this.setupPortKnob(this.dahdsr.decay);
        this.setupPortKnob(this.dahdsr.sustain);
        this.setupPortKnob(this.dahdsr.release);
        this.validate();
    }

    private void setupPortKnob(UnitInputPort port) {
        ExponentialRangeModel model = PortModelFactory.createExponentialModel(port);
        RotaryTextController knob = new RotaryTextController(model, 10);
        knob.setBorder(BorderFactory.createTitledBorder(port.getName()));
        knob.setTitle(port.getName());
        this.add(knob);
    }

    @Override
    public void start() {
        this.synth.start();
        this.lineOut.start();
    }

    @Override
    public void stop() {
        this.synth.stop();
    }

    public static void main(String[] args) {
        HearDAHDSR applet = new HearDAHDSR();
        JAppletFrame frame = new JAppletFrame("Hear DAHDSR Envelope", applet);
        frame.setSize(640, 200);
        frame.setVisible(true);
        frame.test();
    }
}

