/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.instruments.DualOscillatorSynthVoice;
import com.jsyn.midi.MidiSynthesizer;
import com.jsyn.unitgen.LineOut;
import com.jsyn.util.MultiChannelSynthesizer;
import com.jsyn.util.VoiceDescription;
import java.io.IOException;

public class PlayMIDI {
    private static final int NUM_CHANNELS = 16;
    private static final int VOICES_PER_CHANNEL = 6;
    private Synthesizer synth;
    private MidiSynthesizer midiSynthesizer;
    private LineOut lineOut;
    private VoiceDescription voiceDescription;
    private MultiChannelSynthesizer multiSynth;

    public static void main(String[] args) {
        PlayMIDI app = new PlayMIDI();
        try {
            VoiceDescription description = DualOscillatorSynthVoice.getVoiceDescription();
            app.test(description);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public void sendMidiMessage(byte[] bytes) {
        this.midiSynthesizer.onReceive(bytes, 0, bytes.length);
    }

    public void sendNoteOff(int channel, int pitch, int velocity) {
        this.midiCommand(128 + channel, pitch, velocity);
    }

    public void sendNoteOn(int channel, int pitch, int velocity) {
        this.midiCommand(144 + channel, pitch, velocity);
    }

    public void sendControlChange(int channel, int index, int value) {
        this.midiCommand(176 + channel, index, value);
    }

    private void sendProgramChange(int channel, int program) {
        this.midiCommand(192 + channel, program);
    }

    public void sendParameter(int channel, int index14, int value14, int controllerXPN) {
        int indexLsb = index14 & 0x7F;
        int indexMsb = index14 >> 7 & 0x7F;
        int valueLsb = value14 & 0x7F;
        int valueMsb = value14 >> 7 & 0x7F;
        this.sendControlChange(channel, controllerXPN + 1, indexMsb);
        this.sendControlChange(channel, controllerXPN, indexLsb);
        this.sendControlChange(channel, 6, valueMsb);
        this.sendControlChange(channel, 38, valueLsb);
        this.sendControlChange(channel, controllerXPN + 1, 127);
        this.sendControlChange(channel, controllerXPN, 127);
    }

    public void sendRPN(int channel, int index14, int value14) {
        this.sendParameter(channel, index14, value14, 100);
    }

    public void sendNRPN(int channel, int index14, int value14) {
        this.sendParameter(channel, index14, value14, 98);
    }

    private void midiCommand(int status, int data1, int data2) {
        byte[] buffer = new byte[]{(byte)status, (byte)data1, (byte)data2};
        this.sendMidiMessage(buffer);
    }

    private void midiCommand(int status, int data1) {
        byte[] buffer = new byte[]{(byte)status, (byte)data1};
        this.sendMidiMessage(buffer);
    }

    public int test(VoiceDescription description) throws IOException, InterruptedException {
        this.setupSynth(description);
        this.playSameNotesBent();
        int maxChannels = 8;
        int channel = 0;
        while (channel < maxChannels) {
            this.sendProgramChange(channel, channel);
            ++channel;
        }
        this.playNotePerChannel(maxChannels);
        return 0;
    }

    private void playOctaveUsingBend() throws InterruptedException {
        this.sendProgramChange(0, 0);
        float range0 = 12.0f;
        this.sendPitchBendRange(0, range0);
        int i = 0;
        while (i < 13) {
            System.out.println("Bend to pitch " + i);
            this.sendPitchBend(0, (float)i / range0);
            this.sendNoteOn(0, 60, 100);
            this.synth.sleepFor(0.5);
            this.sendNoteOff(0, 60, 100);
            this.synth.sleepFor(0.5);
            ++i;
        }
    }

    private void playSameNotesBent() throws InterruptedException {
        this.sendProgramChange(0, 0);
        this.sendProgramChange(1, 0);
        float range0 = 2.3f;
        float range1 = 6.8f;
        this.sendPitchBendRange(0, range0);
        this.sendPitchBendRange(1, range1);
        this.sendPitchBend(0, 0.0f / range0);
        this.sendPitchBend(1, 1.0f / range1);
        System.out.println("These two notes should play at the same pitch.");
        this.sendNoteOn(0, 61, 100);
        this.synth.sleepFor(0.5);
        this.sendNoteOff(0, 61, 100);
        this.sendNoteOn(1, 60, 100);
        this.synth.sleepFor(0.5);
        this.sendNoteOff(1, 60, 100);
        this.synth.sleepFor(2.0);
        System.out.println("------ done ---------------");
    }

    private void sendPitchBend(int channel, float normalizedBend) {
        boolean BEND_MIN = false;
        int BEND_CENTER = 8192;
        int BEND_MAX = 16383;
        int bend = 8192 + (int)(8192.0f * normalizedBend);
        if (bend < 0) {
            bend = 0;
        } else if (bend > 16383) {
            bend = 16383;
        }
        int lsb = bend & 0x7F;
        int msb = bend >> 7 & 0x7F;
        this.midiCommand(224 + channel, lsb, msb);
    }

    private void sendPitchBendRange(int channel, float range0) {
        int semitones = (int)range0;
        int cents = (int)(100.0f * (range0 - (float)semitones));
        int value = (semitones << 7) + cents;
        this.sendRPN(channel, 0, value);
    }

    private void playNotePerChannel(int maxChannels) throws InterruptedException {
        int channel = 0;
        while (channel < maxChannels) {
            this.sendNoteOn(channel, 60 + channel, 100);
            this.synth.sleepFor(0.5);
            this.sendNoteOff(channel, 60 + channel, 100);
            this.synth.sleepFor(0.5);
            ++channel;
        }
    }

    private void setupSynth(VoiceDescription description) {
        this.synth = JSyn.createSynthesizer();
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.voiceDescription = description;
        this.multiSynth = new MultiChannelSynthesizer();
        boolean startChannel = false;
        this.multiSynth.setup(this.synth, 0, 16, 6, this.voiceDescription);
        this.midiSynthesizer = new MidiSynthesizer(this.multiSynth);
        this.multiSynth.getOutput().connect(0, this.lineOut.input, 0);
        this.multiSynth.getOutput().connect(1, this.lineOut.input, 1);
        this.synth.start();
        this.lineOut.start();
    }
}

