/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.devices.javasound.MidiDeviceTools;
import com.jsyn.instruments.DualOscillatorSynthVoice;
import com.jsyn.midi.MidiSynthesizer;
import com.jsyn.unitgen.LineOut;
import com.jsyn.util.MultiChannelSynthesizer;
import com.jsyn.util.VoiceDescription;
import java.io.IOException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;

public class UseMidiKeyboard {
    private static final int NUM_CHANNELS = 16;
    private static final int VOICES_PER_CHANNEL = 3;
    private Synthesizer synth;
    private LineOut lineOut;
    private MidiSynthesizer midiSynthesizer;
    private VoiceDescription voiceDescription;
    private MultiChannelSynthesizer multiSynth;

    public static void main(String[] args) {
        UseMidiKeyboard app = new UseMidiKeyboard();
        try {
            app.test();
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public int test() throws MidiUnavailableException, IOException, InterruptedException {
        this.setupSynth();
        int result = 2;
        MidiDevice keyboard = MidiDeviceTools.findKeyboard();
        CustomReceiver receiver = new CustomReceiver();
        if (keyboard != null) {
            keyboard.open();
            keyboard.getTransmitter().setReceiver(receiver);
            System.out.println("Play MIDI keyboard: " + keyboard.getDeviceInfo().getDescription());
            result = 0;
        } else {
            System.out.println("Could not find a keyboard.");
        }
        return result;
    }

    private void setupSynth() {
        this.synth = JSyn.createSynthesizer();
        this.voiceDescription = DualOscillatorSynthVoice.getVoiceDescription();
        this.multiSynth = new MultiChannelSynthesizer();
        boolean startChannel = false;
        this.multiSynth.setup(this.synth, 0, 16, 3, this.voiceDescription);
        this.midiSynthesizer = new MidiSynthesizer(this.multiSynth);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.multiSynth.getOutput().connect(0, this.lineOut.input, 0);
        this.multiSynth.getOutput().connect(1, this.lineOut.input, 1);
        this.synth.start();
        this.lineOut.start();
    }

    class CustomReceiver
    implements Receiver {
        CustomReceiver() {
        }

        @Override
        public void close() {
            System.out.print("Closed.");
        }

        @Override
        public void send(MidiMessage message, long timeStamp) {
            byte[] bytes = message.getMessage();
            UseMidiKeyboard.this.midiSynthesizer.onReceive(bytes, 0, bytes.length);
        }
    }
}

