/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.io;

import com.jsyn.io.AudioInputStream;
import com.jsyn.io.AudioOutputStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AudioFifo
implements AudioInputStream,
AudioOutputStream {
    private volatile int readIndex;
    private volatile int writeIndex;
    private volatile double[] buffer;
    private int accessMask;
    private int sizeMask;
    private boolean writeWaitEnabled = true;
    private boolean readWaitEnabled = true;
    final Lock lock = new ReentrantLock();
    final Condition notFull = this.lock.newCondition();
    final Condition notEmpty = this.lock.newCondition();

    public void allocate(int size) {
        if (!AudioFifo.isPowerOfTwo(size)) {
            throw new IllegalArgumentException("Size must be a power of two.");
        }
        this.buffer = new double[size];
        this.accessMask = size - 1;
        this.sizeMask = size * 2 - 1;
    }

    public int size() {
        return this.buffer.length;
    }

    public static boolean isPowerOfTwo(int size) {
        return (size & size - 1) == 0;
    }

    @Override
    public int available() {
        return this.writeIndex - this.readIndex & this.sizeMask;
    }

    @Override
    public void close() {
    }

    @Override
    public double read() {
        double value = Double.NaN;
        if (this.readWaitEnabled) {
            this.lock.lock();
            try {
                while (this.available() < 1) {
                    try {
                        this.notEmpty.await();
                    }
                    catch (InterruptedException e) {
                        this.lock.unlock();
                        return Double.NaN;
                    }
                }
                value = this.readOneInternal();
            }
            finally {
                this.lock.unlock();
            }
        } else if (this.readIndex != this.writeIndex) {
            value = this.readOneInternal();
        }
        if (this.writeWaitEnabled) {
            this.lock.lock();
            this.notFull.signal();
            this.lock.unlock();
        }
        return value;
    }

    private double readOneInternal() {
        double value = this.buffer[this.readIndex & this.accessMask];
        this.readIndex = this.readIndex + 1 & this.sizeMask;
        return value;
    }

    @Override
    public void write(double value) {
        if (this.writeWaitEnabled) {
            this.lock.lock();
            try {
                while (this.available() == this.buffer.length) {
                    try {
                        this.notFull.await();
                    }
                    catch (InterruptedException e) {
                        this.lock.unlock();
                        return;
                    }
                }
                this.writeOneInternal(value);
            }
            finally {
                this.lock.unlock();
            }
        } else if (this.available() != this.buffer.length) {
            this.writeOneInternal(value);
        }
        if (this.readWaitEnabled) {
            this.lock.lock();
            this.notEmpty.signal();
            this.lock.unlock();
        }
    }

    private void writeOneInternal(double value) {
        this.buffer[this.writeIndex & this.accessMask] = value;
        this.writeIndex = this.writeIndex + 1 & this.sizeMask;
    }

    @Override
    public int read(double[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(double[] buffer, int start, int count) {
        if (this.readWaitEnabled) {
            int i = 0;
            while (i < count) {
                buffer[i + start] = this.read();
                ++i;
            }
        } else if (this.available() < count) {
            count = this.available();
        } else {
            int i = 0;
            while (i < count) {
                buffer[i + start] = this.read();
                ++i;
            }
        }
        return count;
    }

    @Override
    public void write(double[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(double[] buffer, int start, int count) {
        int i = 0;
        while (i < count) {
            this.write(buffer[i + start]);
            ++i;
        }
    }

    public void setWriteWaitEnabled(boolean enabled) {
        this.writeWaitEnabled = enabled;
    }

    public void setReadWaitEnabled(boolean enabled) {
        this.readWaitEnabled = enabled;
    }

    public boolean isWriteWaitEnabled() {
        return this.writeWaitEnabled;
    }

    public boolean isReadWaitEnabled() {
        return this.readWaitEnabled;
    }
}

