/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.UnitFilter;

public class PhaseShifter
extends UnitFilter {
    public UnitInputPort offset = new UnitInputPort("Offset", 0.1);
    public UnitInputPort feedback;
    public UnitInputPort depth;
    private double zm1;
    private double[] xs;
    private double[] ys;

    public PhaseShifter() {
        this(6);
    }

    public PhaseShifter(int numStages) {
        this.addPort(this.offset);
        this.feedback = new UnitInputPort("Feedback", 0.7);
        this.addPort(this.feedback);
        this.depth = new UnitInputPort("Depth", 1.0);
        this.addPort(this.depth);
        this.xs = new double[numStages];
        this.ys = new double[numStages];
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] outputs = this.output.getValues();
        double[] feedbacks = this.feedback.getValues();
        double[] depths = this.depth.getValues();
        double[] offsets = this.offset.getValues();
        int i = start;
        while (i < limit) {
            double currentOffset = offsets[i];
            double gain = 1.0 - currentOffset * currentOffset;
            if (gain < -1.0) {
                gain = -1.0;
            }
            double x = inputs[i] + this.zm1 * feedbacks[i];
            int stage = 0;
            while (stage < this.xs.length) {
                double temp = this.ys[stage] = gain * (this.ys[stage] - x) + this.xs[stage];
                this.xs[stage] = x;
                x = temp;
                ++stage;
            }
            this.zm1 = x;
            outputs[i] = inputs[i] + x * depths[i];
            ++i;
        }
    }
}

