/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.data.SpectralWindow;
import com.jsyn.data.Spectrum;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitSpectralOutputPort;
import com.jsyn.unitgen.RectangularWindow;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.math.FourierMath;
import java.util.Arrays;

public class SpectralFFT
extends UnitGenerator {
    public UnitInputPort input;
    public UnitSpectralOutputPort output;
    private double[] buffer;
    private int cursor;
    private SpectralWindow window = RectangularWindow.getInstance();
    private int sizeLog2;
    private int offset;
    private boolean running;

    public SpectralFFT() {
        this(9);
    }

    public SpectralFFT(int sizeLog2) {
        this.input = new UnitInputPort("Input");
        this.addPort(this.input);
        this.output = new UnitSpectralOutputPort("Output", 1 << sizeLog2);
        this.addPort(this.output);
        this.setSizeLog2(sizeLog2);
    }

    public void setSizeLog2(int sizeLog2) {
        this.sizeLog2 = sizeLog2;
        this.output.setSize(1 << sizeLog2);
        this.buffer = this.output.getSpectrum().getReal();
        this.cursor = 0;
    }

    public int getSizeLog2() {
        return this.sizeLog2;
    }

    @Override
    public void generate(int start, int limit) {
        if (!this.running) {
            int mask = (1 << this.sizeLog2) - 1;
            if ((this.getSynthesisEngine().getFrameCount() - (long)this.offset & (long)mask) == 0L) {
                this.running = true;
                this.cursor = 0;
            }
        }
        if (this.running) {
            double[] inputs = this.input.getValues();
            int i = start;
            while (i < limit) {
                this.buffer[this.cursor] = inputs[i] * this.window.get(this.cursor);
                ++this.cursor;
                if (this.cursor == this.buffer.length) {
                    Spectrum spectrum = this.output.getSpectrum();
                    Arrays.fill(spectrum.getImaginary(), 0.0);
                    FourierMath.fft(this.buffer.length, spectrum.getReal(), spectrum.getImaginary());
                    this.output.advance();
                    this.cursor = 0;
                }
                ++i;
            }
        }
    }

    public SpectralWindow getWindow() {
        return this.window;
    }

    public void setWindow(SpectralWindow window) {
        this.window = window;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }
}

