/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DoubleRangeModel {
    private double mMinimum = 0.0;
    private double mValue = 0.0;
    private double mMaximum = 1.0;
    private CopyOnWriteArrayList<ChangeListener> mListeners = new CopyOnWriteArrayList();
    private ChangeEvent mChangeEvent = new ChangeEvent(this);
    private MyBoundedRangeModel mBoundedRangeModel;
    private boolean mValueIsAdjusting;
    private boolean mExponential;

    public DoubleRangeModel(double value, double minimum, double maximum) {
        this(value, minimum, maximum, false);
    }

    public DoubleRangeModel(double value, double minimum, double maximum, boolean exponential) {
        this.mExponential = exponential;
        if (value >= minimum && value <= maximum) {
            if (exponential && minimum < 0.0) {
                throw new IllegalArgumentException("invalid exponential range");
            }
        } else {
            throw new IllegalArgumentException("invalid range");
        }
        this.mMinimum = minimum;
        this.mMaximum = maximum;
        this.mValue = value;
    }

    synchronized BoundedRangeModel getBoundedRangeModel() {
        if (this.mBoundedRangeModel == null) {
            this.mBoundedRangeModel = this.mExponential ? new ExponentialBoundedRangeModel(this) : new MyBoundedRangeModel(this);
        }
        return this.mBoundedRangeModel;
    }

    public boolean getValueIsAdjusting() {
        return this.mValueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean b) {
        this.mValueIsAdjusting = b;
    }

    public double getMinimum() {
        return this.mMinimum;
    }

    public void setMinimum(double minimum) {
        this.mMinimum = minimum;
        this.fireChangeListeners();
    }

    public double getValue() {
        return this.mValue;
    }

    public double clip(double value) {
        if (value < this.mMinimum) {
            value = this.mMinimum;
        } else if (value > this.mMaximum) {
            value = this.mMaximum;
        }
        return value;
    }

    public void setValue(double value) {
        double oldValue = this.mValue;
        this.mValue = value;
        if (value != oldValue) {
            this.fireChangeListeners();
        }
    }

    public double getMaximum() {
        return this.mMaximum;
    }

    public void setMaximum(double maximum) {
        this.mMaximum = maximum;
        this.fireChangeListeners();
    }

    public void addChangeListener(ChangeListener x) {
        this.mListeners.add(x);
    }

    public void removeChangeListener(ChangeListener x) {
        this.mListeners.remove(x);
    }

    private void fireChangeListeners() {
        for (ChangeListener listener : this.mListeners) {
            listener.stateChanged(this.mChangeEvent);
        }
    }

    private static class ExponentialBoundedRangeModel
    extends MyBoundedRangeModel {
        double a = 1.0;
        double b = -1.0;
        double span = 1.0;
        double root = 10.0;

        public ExponentialBoundedRangeModel(DoubleRangeModel doubleRangeModel) {
            super(doubleRangeModel);
            this.updateCoefficients();
        }

        private void updateCoefficients() {
            this.a = (this.mDoubleModel.mMaximum - this.mDoubleModel.mMinimum) / (Math.pow(this.root, this.span) - 1.0);
            this.b = this.mDoubleModel.mMinimum - this.a;
        }

        @Override
        public double sliderToDouble(int sliderValue) {
            this.updateCoefficients();
            double x = (double)sliderValue / (double)this.getMaximum();
            double y = this.a * Math.pow(this.root, this.span * x) + this.b;
            return y;
        }

        @Override
        public int doubleToSlider(double dval) {
            this.updateCoefficients();
            double z = (dval - this.b) / this.a;
            double x = Math.log(z) / (this.span * Math.log(this.root));
            return (int)Math.round(x * (double)this.getMaximum());
        }
    }

    private static class MyBoundedRangeModel
    implements BoundedRangeModel {
        private CopyOnWriteArrayList<ChangeListener> mIntegerListeners = new CopyOnWriteArrayList();
        private ChangeEvent mChangeEvent = new ChangeEvent(this);
        private int mResolution = 10000000;
        protected DoubleRangeModel mDoubleModel;

        public MyBoundedRangeModel(DoubleRangeModel doubleRangeModel) {
            this.mDoubleModel = doubleRangeModel;
        }

        protected double sliderToDouble(int sliderValue) {
            return this.mDoubleModel.mMinimum + (this.mDoubleModel.mMaximum - this.mDoubleModel.mMinimum) * (double)sliderValue / (double)this.mResolution;
        }

        protected int doubleToSlider(double dval) {
            return (int)Math.floor((double)this.mResolution * (dval - this.mDoubleModel.mMinimum) / (this.mDoubleModel.mMaximum - this.mDoubleModel.mMinimum));
        }

        @Override
        public int getMinimum() {
            return 0;
        }

        @Override
        public void setMinimum(int newMinimum) {
            throw new IllegalArgumentException("Cannot change.");
        }

        @Override
        public int getMaximum() {
            return this.mResolution;
        }

        @Override
        public void setMaximum(int newMaximum) {
            this.mResolution = newMaximum;
        }

        @Override
        public int getValue() {
            return this.doubleToSlider(this.mDoubleModel.mValue);
        }

        @Override
        public void setValue(int newValue) {
            double value = this.sliderToDouble(newValue);
            double clippedValue = this.mDoubleModel.clip(value);
            this.mDoubleModel.setValue(clippedValue);
        }

        @Override
        public void setValueIsAdjusting(boolean b) {
            this.mDoubleModel.setValueIsAdjusting(b);
        }

        @Override
        public boolean getValueIsAdjusting() {
            return this.mDoubleModel.getValueIsAdjusting();
        }

        @Override
        public int getExtent() {
            return 0;
        }

        @Override
        public void setExtent(int newExtent) {
            throw new IllegalArgumentException("Cannot change.");
        }

        @Override
        public void setRangeProperties(int value, int extent, int min, int max, boolean adjusting) {
            throw new IllegalArgumentException("Cannot change.");
        }

        @Override
        public void addChangeListener(ChangeListener x) {
            this.mDoubleModel.addChangeListener(x);
        }

        @Override
        public void removeChangeListener(ChangeListener x) {
            this.mDoubleModel.removeChangeListener(x);
        }
    }
}

