/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.syntona.gui.patch.JackPartner;
import com.syntona.model.SyntonaExporter;
import com.syntona.model.SyntonaSaver;
import com.syntona.plugin.ConnectionHandler;
import com.syntona.plugin.InputJack;
import com.syntona.plugin.JackEditor;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.OutputJack;
import com.syntona.plugin.PatchMessage;
import com.syntona.plugin.SyntonaModel;
import com.syntona.plugin.SyntonaModule;
import java.awt.Color;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public abstract class Jack
extends SyntonaModel {
    SyntonaModule owner;
    private CopyOnWriteArrayList<Jack> connected = new CopyOnWriteArrayList();
    private JackPartner partner;
    private Logger logger = Logger.getLogger(Jack.class.getName());
    private boolean visible = true;
    private boolean connectable = true;
    private ConnectionHandler connectionHandler;
    public static final int VIEW_TYPE_BASIC = 0;
    public static final int VIEW_TYPE_BUTTON = 1;
    public static final int VIEW_TYPE_KNOB = 2;
    public static final int VIEW_TYPE_GRID = 3;
    private int viewType = 0;
    private Jack levelWith;

    public Jack(SyntonaModule owner, String name, String help) {
        super(name, help);
        this.owner = owner;
        owner.addJack(this);
    }

    public int getViewType() {
        return this.viewType;
    }

    public void setViewType(int viewType) {
        this.viewType = viewType;
    }

    public void loadContents(Element jackElement) {
    }

    public void save(SyntonaSaver saver) {
        saver.beginElement("jack");
        saver.addAttribute("name", this.name);
        saver.endElement();
    }

    public abstract void passMessage(PatchMessage var1);

    public boolean willAccept(Jack other) {
        if (this.isConnected(other)) {
            return false;
        }
        return other.isOutput() != this.isOutput();
    }

    public abstract boolean isOutput();

    private boolean isConnected(Jack other) {
        return this.connected.contains(other);
    }

    public void addConnection(Jack other) {
        this.connected.add(other);
    }

    public void removeConnection(Jack other) {
        this.connected.remove(other);
    }

    public void connect(Jack other) {
        this.logger.fine("Connect " + this + " to " + other);
        if (this.willAccept(other) && other.willAccept(this)) {
            this.addConnection(other);
            other.addConnection(this);
            if (this.connectionHandler != null) {
                this.connectionHandler.connectedTo((OutputJack)this, (InputJack)other);
            }
        }
    }

    public void setConnectionHandler(ConnectionHandler handler) {
        this.connectionHandler = handler;
    }

    public int getConnectedCount() {
        return this.connected.size();
    }

    public Iterator<Jack> getConnected() {
        return this.connected.iterator();
    }

    public SyntonaModule getModule() {
        return this.owner;
    }

    public Jack getConnected(int i) {
        return this.connected.get(i);
    }

    public void disconnect(Jack other) {
        this.removeConnection(other);
        other.removeConnection(this);
    }

    public JackPartner getPartner() {
        return this.partner;
    }

    public void setPartner(JackPartner partner) {
        this.partner = partner;
    }

    public void disconnect() {
        Jack[] jacks;
        Jack[] jackArray = jacks = this.connected.toArray(new Jack[0]);
        int n = jacks.length;
        int n2 = 0;
        while (n2 < n) {
            Jack otherJack = jackArray[n2];
            this.disconnect(otherJack);
            ++n2;
        }
    }

    public String getValueText() {
        return "?";
    }

    public JackEditor getEditor(ModulePresenter modulePresenter) {
        return null;
    }

    public Color getColor() {
        return Color.WHITE;
    }

    public Color getSignalColor() {
        return Color.BLACK;
    }

    public void exportJavaSource(SyntonaExporter exporter, int phase) {
    }

    public void setVisible(boolean flag) {
        this.visible = flag;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isConnectable() {
        return this.connectable;
    }

    public void setConnectable(boolean connectable) {
        this.connectable = connectable;
    }

    public void setLevelWith(Jack jack) {
        this.levelWith = jack;
    }

    public Jack getLevelWith() {
        return this.levelWith;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ", " + this.getName();
    }
}

